/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.calendar;

import java.util.Arrays;
import javax.annotation.Nonnull;

public enum Month {
    JANUARY(66.5f),
    FEBRUARY(65.5f),
    MARCH(56.0f),
    APRIL(47.5f),
    MAY(38.0f),
    JUNE(29.5f),
    JULY(27.0f),
    AUGUST(29.5f),
    SEPTEMBER(38.0f),
    OCTOBER(47.5f),
    NOVEMBER(56.0f),
    DECEMBER(65.5f);

    private static final Month[] VALUES;
    public static final float AVERAGE_TEMPERATURE_MODIFIER;
    private final float temperatureModifier;

    @Nonnull
    public static Month valueOf(int id) {
        return id >= 0 && id < VALUES.length ? VALUES[id] : JANUARY;
    }

    private Month(float temperatureModifier) {
        this.temperatureModifier = temperatureModifier;
    }

    public float getTemperatureModifier() {
        return this.temperatureModifier;
    }

    public Month next() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    public boolean isWithin(Month lowerBoundInclusive, Month upperBoundInclusive) {
        if (lowerBoundInclusive.ordinal() <= upperBoundInclusive.ordinal()) {
            return this.ordinal() >= lowerBoundInclusive.ordinal() && this.ordinal() <= upperBoundInclusive.ordinal();
        }
        return this.ordinal() >= lowerBoundInclusive.ordinal() || this.ordinal() <= upperBoundInclusive.ordinal();
    }

    static {
        VALUES = Month.values();
        AVERAGE_TEMPERATURE_MODIFIER = (float)Arrays.stream(VALUES).mapToDouble(Month::getTemperatureModifier).average().orElse(0.0);
    }
}

